package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

/**
 * A field to access the active cart.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = InStoreMe.class, name = "InStoreMe"),
    @JsonSubTypes.Type(value = Me.class, name = "Me")
})
public interface ActiveCartInterface {
  Cart getActiveCart();

  void setActiveCart(Cart activeCart);
}
