package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddBusinessUnitStore {
  private ResourceIdentifierInput store;

  public AddBusinessUnitStore() {
  }

  public AddBusinessUnitStore(ResourceIdentifierInput store) {
    this.store = store;
  }

  public ResourceIdentifierInput getStore() {
    return store;
  }

  public void setStore(ResourceIdentifierInput store) {
    this.store = store;
  }

  @Override
  public String toString() {
    return "AddBusinessUnitStore{store='" + store + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddBusinessUnitStore that = (AddBusinessUnitStore) o;
    return Objects.equals(store, that.store);
  }

  @Override
  public int hashCode() {
    return Objects.hash(store);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput store;

    public AddBusinessUnitStore build() {
      AddBusinessUnitStore result = new AddBusinessUnitStore();
      result.store = this.store;
      return result;
    }

    public Builder store(ResourceIdentifierInput store) {
      this.store = store;
      return this;
    }
  }
}
