package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddCategoryAsset {
  private Integer position;

  private AssetDraftInput asset;

  public AddCategoryAsset() {
  }

  public AddCategoryAsset(Integer position, AssetDraftInput asset) {
    this.position = position;
    this.asset = asset;
  }

  public Integer getPosition() {
    return position;
  }

  public void setPosition(Integer position) {
    this.position = position;
  }

  public AssetDraftInput getAsset() {
    return asset;
  }

  public void setAsset(AssetDraftInput asset) {
    this.asset = asset;
  }

  @Override
  public String toString() {
    return "AddCategoryAsset{position='" + position + "', asset='" + asset + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddCategoryAsset that = (AddCategoryAsset) o;
    return Objects.equals(position, that.position) &&
        Objects.equals(asset, that.asset);
  }

  @Override
  public int hashCode() {
    return Objects.hash(position, asset);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer position;

    private AssetDraftInput asset;

    public AddCategoryAsset build() {
      AddCategoryAsset result = new AddCategoryAsset();
      result.position = this.position;
      result.asset = this.asset;
      return result;
    }

    public Builder position(Integer position) {
      this.position = position;
      return this;
    }

    public Builder asset(AssetDraftInput asset) {
      this.asset = asset;
      return this;
    }
  }
}
