package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddInventoryEntryQuantity {
  private Long quantity;

  public AddInventoryEntryQuantity() {
  }

  public AddInventoryEntryQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  @Override
  public String toString() {
    return "AddInventoryEntryQuantity{quantity='" + quantity + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddInventoryEntryQuantity that = (AddInventoryEntryQuantity) o;
    return Objects.equals(quantity, that.quantity);
  }

  @Override
  public int hashCode() {
    return Objects.hash(quantity);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Long quantity;

    public AddInventoryEntryQuantity build() {
      AddInventoryEntryQuantity result = new AddInventoryEntryQuantity();
      result.quantity = this.quantity;
      return result;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }
  }
}
