package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class AddMyCartLineItem {
  private OffsetDateTime addedAt;

  private ItemShippingDetailsDraft shippingDetails;

  private CustomFieldsDraft custom;

  private ResourceIdentifierInput distributionChannel;

  private ResourceIdentifierInput supplyChannel;

  private Integer variantId;

  private Long quantity;

  private String sku;

  private String key;

  private String productId;

  public AddMyCartLineItem() {
  }

  public AddMyCartLineItem(OffsetDateTime addedAt, ItemShippingDetailsDraft shippingDetails,
      CustomFieldsDraft custom, ResourceIdentifierInput distributionChannel,
      ResourceIdentifierInput supplyChannel, Integer variantId, Long quantity, String sku,
      String key, String productId) {
    this.addedAt = addedAt;
    this.shippingDetails = shippingDetails;
    this.custom = custom;
    this.distributionChannel = distributionChannel;
    this.supplyChannel = supplyChannel;
    this.variantId = variantId;
    this.quantity = quantity;
    this.sku = sku;
    this.key = key;
    this.productId = productId;
  }

  public OffsetDateTime getAddedAt() {
    return addedAt;
  }

  public void setAddedAt(OffsetDateTime addedAt) {
    this.addedAt = addedAt;
  }

  public ItemShippingDetailsDraft getShippingDetails() {
    return shippingDetails;
  }

  public void setShippingDetails(ItemShippingDetailsDraft shippingDetails) {
    this.shippingDetails = shippingDetails;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public ResourceIdentifierInput getDistributionChannel() {
    return distributionChannel;
  }

  public void setDistributionChannel(ResourceIdentifierInput distributionChannel) {
    this.distributionChannel = distributionChannel;
  }

  public ResourceIdentifierInput getSupplyChannel() {
    return supplyChannel;
  }

  public void setSupplyChannel(ResourceIdentifierInput supplyChannel) {
    this.supplyChannel = supplyChannel;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getProductId() {
    return productId;
  }

  public void setProductId(String productId) {
    this.productId = productId;
  }

  @Override
  public String toString() {
    return "AddMyCartLineItem{addedAt='" + addedAt + "', shippingDetails='" + shippingDetails + "', custom='" + custom + "', distributionChannel='" + distributionChannel + "', supplyChannel='" + supplyChannel + "', variantId='" + variantId + "', quantity='" + quantity + "', sku='" + sku + "', key='" + key + "', productId='" + productId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddMyCartLineItem that = (AddMyCartLineItem) o;
    return Objects.equals(addedAt, that.addedAt) &&
        Objects.equals(shippingDetails, that.shippingDetails) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(distributionChannel, that.distributionChannel) &&
        Objects.equals(supplyChannel, that.supplyChannel) &&
        Objects.equals(variantId, that.variantId) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(key, that.key) &&
        Objects.equals(productId, that.productId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addedAt, shippingDetails, custom, distributionChannel, supplyChannel, variantId, quantity, sku, key, productId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OffsetDateTime addedAt;

    private ItemShippingDetailsDraft shippingDetails;

    private CustomFieldsDraft custom;

    private ResourceIdentifierInput distributionChannel;

    private ResourceIdentifierInput supplyChannel;

    private Integer variantId;

    private Long quantity;

    private String sku;

    private String key;

    private String productId;

    public AddMyCartLineItem build() {
      AddMyCartLineItem result = new AddMyCartLineItem();
      result.addedAt = this.addedAt;
      result.shippingDetails = this.shippingDetails;
      result.custom = this.custom;
      result.distributionChannel = this.distributionChannel;
      result.supplyChannel = this.supplyChannel;
      result.variantId = this.variantId;
      result.quantity = this.quantity;
      result.sku = this.sku;
      result.key = this.key;
      result.productId = this.productId;
      return result;
    }

    public Builder addedAt(OffsetDateTime addedAt) {
      this.addedAt = addedAt;
      return this;
    }

    public Builder shippingDetails(ItemShippingDetailsDraft shippingDetails) {
      this.shippingDetails = shippingDetails;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder distributionChannel(ResourceIdentifierInput distributionChannel) {
      this.distributionChannel = distributionChannel;
      return this;
    }

    public Builder supplyChannel(ResourceIdentifierInput supplyChannel) {
      this.supplyChannel = supplyChannel;
      return this;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder productId(String productId) {
      this.productId = productId;
      return this;
    }
  }
}
