package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddOrderEditStagedAction {
  private StagedOrderUpdateAction stagedAction;

  public AddOrderEditStagedAction() {
  }

  public AddOrderEditStagedAction(StagedOrderUpdateAction stagedAction) {
    this.stagedAction = stagedAction;
  }

  public StagedOrderUpdateAction getStagedAction() {
    return stagedAction;
  }

  public void setStagedAction(StagedOrderUpdateAction stagedAction) {
    this.stagedAction = stagedAction;
  }

  @Override
  public String toString() {
    return "AddOrderEditStagedAction{stagedAction='" + stagedAction + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddOrderEditStagedAction that = (AddOrderEditStagedAction) o;
    return Objects.equals(stagedAction, that.stagedAction);
  }

  @Override
  public int hashCode() {
    return Objects.hash(stagedAction);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private StagedOrderUpdateAction stagedAction;

    public AddOrderEditStagedAction build() {
      AddOrderEditStagedAction result = new AddOrderEditStagedAction();
      result.stagedAction = this.stagedAction;
      return result;
    }

    public Builder stagedAction(StagedOrderUpdateAction stagedAction) {
      this.stagedAction = stagedAction;
      return this;
    }
  }
}
