package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddPaymentTransaction {
  private TransactionDraft transaction;

  public AddPaymentTransaction() {
  }

  public AddPaymentTransaction(TransactionDraft transaction) {
    this.transaction = transaction;
  }

  public TransactionDraft getTransaction() {
    return transaction;
  }

  public void setTransaction(TransactionDraft transaction) {
    this.transaction = transaction;
  }

  @Override
  public String toString() {
    return "AddPaymentTransaction{transaction='" + transaction + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddPaymentTransaction that = (AddPaymentTransaction) o;
    return Objects.equals(transaction, that.transaction);
  }

  @Override
  public int hashCode() {
    return Objects.hash(transaction);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private TransactionDraft transaction;

    public AddPaymentTransaction build() {
      AddPaymentTransaction result = new AddPaymentTransaction();
      result.transaction = this.transaction;
      return result;
    }

    public Builder transaction(TransactionDraft transaction) {
      this.transaction = transaction;
      return this;
    }
  }
}
