package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddProductPrice {
  private Integer variantId;

  private String sku;

  private ProductPriceDataInput price;

  private Boolean staged = true;

  public AddProductPrice() {
  }

  public AddProductPrice(Integer variantId, String sku, ProductPriceDataInput price,
      Boolean staged) {
    this.variantId = variantId;
    this.sku = sku;
    this.price = price;
    this.staged = staged;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public ProductPriceDataInput getPrice() {
    return price;
  }

  public void setPrice(ProductPriceDataInput price) {
    this.price = price;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "AddProductPrice{variantId='" + variantId + "', sku='" + sku + "', price='" + price + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddProductPrice that = (AddProductPrice) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(price, that.price) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, sku, price, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private String sku;

    private ProductPriceDataInput price;

    private Boolean staged = true;

    public AddProductPrice build() {
      AddProductPrice result = new AddProductPrice();
      result.variantId = this.variantId;
      result.sku = this.sku;
      result.price = this.price;
      result.staged = this.staged;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder price(ProductPriceDataInput price) {
      this.price = price;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
