package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddShippingMethodShippingRate {
  private ResourceIdentifierInput zone;

  private ShippingRateDraft shippingRate;

  public AddShippingMethodShippingRate() {
  }

  public AddShippingMethodShippingRate(ResourceIdentifierInput zone,
      ShippingRateDraft shippingRate) {
    this.zone = zone;
    this.shippingRate = shippingRate;
  }

  public ResourceIdentifierInput getZone() {
    return zone;
  }

  public void setZone(ResourceIdentifierInput zone) {
    this.zone = zone;
  }

  public ShippingRateDraft getShippingRate() {
    return shippingRate;
  }

  public void setShippingRate(ShippingRateDraft shippingRate) {
    this.shippingRate = shippingRate;
  }

  @Override
  public String toString() {
    return "AddShippingMethodShippingRate{zone='" + zone + "', shippingRate='" + shippingRate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddShippingMethodShippingRate that = (AddShippingMethodShippingRate) o;
    return Objects.equals(zone, that.zone) &&
        Objects.equals(shippingRate, that.shippingRate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(zone, shippingRate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput zone;

    private ShippingRateDraft shippingRate;

    public AddShippingMethodShippingRate build() {
      AddShippingMethodShippingRate result = new AddShippingMethodShippingRate();
      result.zone = this.zone;
      result.shippingRate = this.shippingRate;
      return result;
    }

    public Builder zone(ResourceIdentifierInput zone) {
      this.zone = zone;
      return this;
    }

    public Builder shippingRate(ShippingRateDraft shippingRate) {
      this.shippingRate = shippingRate;
      return this;
    }
  }
}
