package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

public class AddShoppingListTextLineItem {
  private OffsetDateTime addedAt;

  private CustomFieldsDraft custom;

  private Integer quantity = 1;

  private List<LocalizedStringItemInputType> description;

  private List<LocalizedStringItemInputType> name;

  private String key;

  public AddShoppingListTextLineItem() {
  }

  public AddShoppingListTextLineItem(OffsetDateTime addedAt, CustomFieldsDraft custom,
      Integer quantity, List<LocalizedStringItemInputType> description,
      List<LocalizedStringItemInputType> name, String key) {
    this.addedAt = addedAt;
    this.custom = custom;
    this.quantity = quantity;
    this.description = description;
    this.name = name;
    this.key = key;
  }

  public OffsetDateTime getAddedAt() {
    return addedAt;
  }

  public void setAddedAt(OffsetDateTime addedAt) {
    this.addedAt = addedAt;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public Integer getQuantity() {
    return quantity;
  }

  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  @Override
  public String toString() {
    return "AddShoppingListTextLineItem{addedAt='" + addedAt + "', custom='" + custom + "', quantity='" + quantity + "', description='" + description + "', name='" + name + "', key='" + key + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddShoppingListTextLineItem that = (AddShoppingListTextLineItem) o;
    return Objects.equals(addedAt, that.addedAt) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(description, that.description) &&
        Objects.equals(name, that.name) &&
        Objects.equals(key, that.key);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addedAt, custom, quantity, description, name, key);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OffsetDateTime addedAt;

    private CustomFieldsDraft custom;

    private Integer quantity = 1;

    private List<LocalizedStringItemInputType> description;

    private List<LocalizedStringItemInputType> name;

    private String key;

    public AddShoppingListTextLineItem build() {
      AddShoppingListTextLineItem result = new AddShoppingListTextLineItem();
      result.addedAt = this.addedAt;
      result.custom = this.custom;
      result.quantity = this.quantity;
      result.description = this.description;
      result.name = this.name;
      result.key = this.key;
      return result;
    }

    public Builder addedAt(OffsetDateTime addedAt) {
      this.addedAt = addedAt;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder quantity(Integer quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }
  }
}
