package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class AddStagedOrderCustomLineItem {
  private CustomLineItemPriceMode priceMode = CustomLineItemPriceMode.Standard;

  private ItemShippingDetailsDraftType shippingDetails;

  private CustomFieldsDraft custom;

  private Long quantity;

  private ExternalTaxRateDraft externalTaxRate;

  private ResourceIdentifierInput taxCategory;

  private String slug;

  private BaseMoneyInput money;

  private String key;

  private List<LocalizedStringItemInputType> name;

  public AddStagedOrderCustomLineItem() {
  }

  public AddStagedOrderCustomLineItem(CustomLineItemPriceMode priceMode,
      ItemShippingDetailsDraftType shippingDetails, CustomFieldsDraft custom, Long quantity,
      ExternalTaxRateDraft externalTaxRate, ResourceIdentifierInput taxCategory, String slug,
      BaseMoneyInput money, String key, List<LocalizedStringItemInputType> name) {
    this.priceMode = priceMode;
    this.shippingDetails = shippingDetails;
    this.custom = custom;
    this.quantity = quantity;
    this.externalTaxRate = externalTaxRate;
    this.taxCategory = taxCategory;
    this.slug = slug;
    this.money = money;
    this.key = key;
    this.name = name;
  }

  public CustomLineItemPriceMode getPriceMode() {
    return priceMode;
  }

  public void setPriceMode(CustomLineItemPriceMode priceMode) {
    this.priceMode = priceMode;
  }

  public ItemShippingDetailsDraftType getShippingDetails() {
    return shippingDetails;
  }

  public void setShippingDetails(ItemShippingDetailsDraftType shippingDetails) {
    this.shippingDetails = shippingDetails;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public ExternalTaxRateDraft getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraft externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  public ResourceIdentifierInput getTaxCategory() {
    return taxCategory;
  }

  public void setTaxCategory(ResourceIdentifierInput taxCategory) {
    this.taxCategory = taxCategory;
  }

  public String getSlug() {
    return slug;
  }

  public void setSlug(String slug) {
    this.slug = slug;
  }

  public BaseMoneyInput getMoney() {
    return money;
  }

  public void setMoney(BaseMoneyInput money) {
    this.money = money;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "AddStagedOrderCustomLineItem{priceMode='" + priceMode + "', shippingDetails='" + shippingDetails + "', custom='" + custom + "', quantity='" + quantity + "', externalTaxRate='" + externalTaxRate + "', taxCategory='" + taxCategory + "', slug='" + slug + "', money='" + money + "', key='" + key + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddStagedOrderCustomLineItem that = (AddStagedOrderCustomLineItem) o;
    return Objects.equals(priceMode, that.priceMode) &&
        Objects.equals(shippingDetails, that.shippingDetails) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(externalTaxRate, that.externalTaxRate) &&
        Objects.equals(taxCategory, that.taxCategory) &&
        Objects.equals(slug, that.slug) &&
        Objects.equals(money, that.money) &&
        Objects.equals(key, that.key) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(priceMode, shippingDetails, custom, quantity, externalTaxRate, taxCategory, slug, money, key, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CustomLineItemPriceMode priceMode = CustomLineItemPriceMode.Standard;

    private ItemShippingDetailsDraftType shippingDetails;

    private CustomFieldsDraft custom;

    private Long quantity;

    private ExternalTaxRateDraft externalTaxRate;

    private ResourceIdentifierInput taxCategory;

    private String slug;

    private BaseMoneyInput money;

    private String key;

    private List<LocalizedStringItemInputType> name;

    public AddStagedOrderCustomLineItem build() {
      AddStagedOrderCustomLineItem result = new AddStagedOrderCustomLineItem();
      result.priceMode = this.priceMode;
      result.shippingDetails = this.shippingDetails;
      result.custom = this.custom;
      result.quantity = this.quantity;
      result.externalTaxRate = this.externalTaxRate;
      result.taxCategory = this.taxCategory;
      result.slug = this.slug;
      result.money = this.money;
      result.key = this.key;
      result.name = this.name;
      return result;
    }

    public Builder priceMode(CustomLineItemPriceMode priceMode) {
      this.priceMode = priceMode;
      return this;
    }

    public Builder shippingDetails(ItemShippingDetailsDraftType shippingDetails) {
      this.shippingDetails = shippingDetails;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraft externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }

    public Builder taxCategory(ResourceIdentifierInput taxCategory) {
      this.taxCategory = taxCategory;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = slug;
      return this;
    }

    public Builder money(BaseMoneyInput money) {
      this.money = money;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }
  }
}
