package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AddStagedOrderCustomLineItemOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private CustomLineItemDraftOutput draft;

  public AddStagedOrderCustomLineItemOutput() {
  }

  public AddStagedOrderCustomLineItemOutput(String type, CustomLineItemDraftOutput draft) {
    this.type = type;
    this.draft = draft;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public CustomLineItemDraftOutput getDraft() {
    return draft;
  }

  public void setDraft(CustomLineItemDraftOutput draft) {
    this.draft = draft;
  }

  @Override
  public String toString() {
    return "AddStagedOrderCustomLineItemOutput{type='" + type + "', draft='" + draft + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddStagedOrderCustomLineItemOutput that = (AddStagedOrderCustomLineItemOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(draft, that.draft);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, draft);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private CustomLineItemDraftOutput draft;

    public AddStagedOrderCustomLineItemOutput build() {
      AddStagedOrderCustomLineItemOutput result = new AddStagedOrderCustomLineItemOutput();
      result.type = this.type;
      result.draft = this.draft;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder draft(CustomLineItemDraftOutput draft) {
      this.draft = draft;
      return this;
    }
  }
}
