package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AddStagedOrderDeliveryOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String deliveryKey;

  private List<DeliveryItem> items;

  private List<ParcelData> parcels;

  private AddressDraft address;

  private CustomFieldsCommand custom;

  private String shippingKey;

  public AddStagedOrderDeliveryOutput() {
  }

  public AddStagedOrderDeliveryOutput(String type, String deliveryKey, List<DeliveryItem> items,
      List<ParcelData> parcels, AddressDraft address, CustomFieldsCommand custom,
      String shippingKey) {
    this.type = type;
    this.deliveryKey = deliveryKey;
    this.items = items;
    this.parcels = parcels;
    this.address = address;
    this.custom = custom;
    this.shippingKey = shippingKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getDeliveryKey() {
    return deliveryKey;
  }

  public void setDeliveryKey(String deliveryKey) {
    this.deliveryKey = deliveryKey;
  }

  public List<DeliveryItem> getItems() {
    return items;
  }

  public void setItems(List<DeliveryItem> items) {
    this.items = items;
  }

  public List<ParcelData> getParcels() {
    return parcels;
  }

  public void setParcels(List<ParcelData> parcels) {
    this.parcels = parcels;
  }

  public AddressDraft getAddress() {
    return address;
  }

  public void setAddress(AddressDraft address) {
    this.address = address;
  }

  public CustomFieldsCommand getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsCommand custom) {
    this.custom = custom;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  @Override
  public String toString() {
    return "AddStagedOrderDeliveryOutput{type='" + type + "', deliveryKey='" + deliveryKey + "', items='" + items + "', parcels='" + parcels + "', address='" + address + "', custom='" + custom + "', shippingKey='" + shippingKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddStagedOrderDeliveryOutput that = (AddStagedOrderDeliveryOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(deliveryKey, that.deliveryKey) &&
        Objects.equals(items, that.items) &&
        Objects.equals(parcels, that.parcels) &&
        Objects.equals(address, that.address) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(shippingKey, that.shippingKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, deliveryKey, items, parcels, address, custom, shippingKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String deliveryKey;

    private List<DeliveryItem> items;

    private List<ParcelData> parcels;

    private AddressDraft address;

    private CustomFieldsCommand custom;

    private String shippingKey;

    public AddStagedOrderDeliveryOutput build() {
      AddStagedOrderDeliveryOutput result = new AddStagedOrderDeliveryOutput();
      result.type = this.type;
      result.deliveryKey = this.deliveryKey;
      result.items = this.items;
      result.parcels = this.parcels;
      result.address = this.address;
      result.custom = this.custom;
      result.shippingKey = this.shippingKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder deliveryKey(String deliveryKey) {
      this.deliveryKey = deliveryKey;
      return this;
    }

    public Builder items(List<DeliveryItem> items) {
      this.items = items;
      return this;
    }

    public Builder parcels(List<ParcelData> parcels) {
      this.parcels = parcels;
      return this;
    }

    public Builder address(AddressDraft address) {
      this.address = address;
      return this;
    }

    public Builder custom(CustomFieldsCommand custom) {
      this.custom = custom;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }
  }
}
