package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AddStagedOrderLineItemOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private LineItemDraftOutput draft;

  public AddStagedOrderLineItemOutput() {
  }

  public AddStagedOrderLineItemOutput(String type, LineItemDraftOutput draft) {
    this.type = type;
    this.draft = draft;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public LineItemDraftOutput getDraft() {
    return draft;
  }

  public void setDraft(LineItemDraftOutput draft) {
    this.draft = draft;
  }

  @Override
  public String toString() {
    return "AddStagedOrderLineItemOutput{type='" + type + "', draft='" + draft + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddStagedOrderLineItemOutput that = (AddStagedOrderLineItemOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(draft, that.draft);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, draft);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private LineItemDraftOutput draft;

    public AddStagedOrderLineItemOutput build() {
      AddStagedOrderLineItemOutput result = new AddStagedOrderLineItemOutput();
      result.type = this.type;
      result.draft = this.draft;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder draft(LineItemDraftOutput draft) {
      this.draft = draft;
      return this;
    }
  }
}
