package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AddStagedOrderParcelToDeliveryOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String deliveryId;

  private String deliveryKey;

  private String parcelKey;

  private ParcelMeasurements measurements;

  private TrackingData trackingData;

  private List<DeliveryItem> items;

  private CustomFieldsCommand custom;

  public AddStagedOrderParcelToDeliveryOutput() {
  }

  public AddStagedOrderParcelToDeliveryOutput(String type, String deliveryId, String deliveryKey,
      String parcelKey, ParcelMeasurements measurements, TrackingData trackingData,
      List<DeliveryItem> items, CustomFieldsCommand custom) {
    this.type = type;
    this.deliveryId = deliveryId;
    this.deliveryKey = deliveryKey;
    this.parcelKey = parcelKey;
    this.measurements = measurements;
    this.trackingData = trackingData;
    this.items = items;
    this.custom = custom;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getDeliveryId() {
    return deliveryId;
  }

  public void setDeliveryId(String deliveryId) {
    this.deliveryId = deliveryId;
  }

  public String getDeliveryKey() {
    return deliveryKey;
  }

  public void setDeliveryKey(String deliveryKey) {
    this.deliveryKey = deliveryKey;
  }

  public String getParcelKey() {
    return parcelKey;
  }

  public void setParcelKey(String parcelKey) {
    this.parcelKey = parcelKey;
  }

  public ParcelMeasurements getMeasurements() {
    return measurements;
  }

  public void setMeasurements(ParcelMeasurements measurements) {
    this.measurements = measurements;
  }

  public TrackingData getTrackingData() {
    return trackingData;
  }

  public void setTrackingData(TrackingData trackingData) {
    this.trackingData = trackingData;
  }

  public List<DeliveryItem> getItems() {
    return items;
  }

  public void setItems(List<DeliveryItem> items) {
    this.items = items;
  }

  public CustomFieldsCommand getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsCommand custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "AddStagedOrderParcelToDeliveryOutput{type='" + type + "', deliveryId='" + deliveryId + "', deliveryKey='" + deliveryKey + "', parcelKey='" + parcelKey + "', measurements='" + measurements + "', trackingData='" + trackingData + "', items='" + items + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddStagedOrderParcelToDeliveryOutput that = (AddStagedOrderParcelToDeliveryOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(deliveryId, that.deliveryId) &&
        Objects.equals(deliveryKey, that.deliveryKey) &&
        Objects.equals(parcelKey, that.parcelKey) &&
        Objects.equals(measurements, that.measurements) &&
        Objects.equals(trackingData, that.trackingData) &&
        Objects.equals(items, that.items) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, deliveryId, deliveryKey, parcelKey, measurements, trackingData, items, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String deliveryId;

    private String deliveryKey;

    private String parcelKey;

    private ParcelMeasurements measurements;

    private TrackingData trackingData;

    private List<DeliveryItem> items;

    private CustomFieldsCommand custom;

    public AddStagedOrderParcelToDeliveryOutput build() {
      AddStagedOrderParcelToDeliveryOutput result = new AddStagedOrderParcelToDeliveryOutput();
      result.type = this.type;
      result.deliveryId = this.deliveryId;
      result.deliveryKey = this.deliveryKey;
      result.parcelKey = this.parcelKey;
      result.measurements = this.measurements;
      result.trackingData = this.trackingData;
      result.items = this.items;
      result.custom = this.custom;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder deliveryId(String deliveryId) {
      this.deliveryId = deliveryId;
      return this;
    }

    public Builder deliveryKey(String deliveryKey) {
      this.deliveryKey = deliveryKey;
      return this;
    }

    public Builder parcelKey(String parcelKey) {
      this.parcelKey = parcelKey;
      return this;
    }

    public Builder measurements(ParcelMeasurements measurements) {
      this.measurements = measurements;
      return this;
    }

    public Builder trackingData(TrackingData trackingData) {
      this.trackingData = trackingData;
      return this;
    }

    public Builder items(List<DeliveryItem> items) {
      this.items = items;
      return this;
    }

    public Builder custom(CustomFieldsCommand custom) {
      this.custom = custom;
      return this;
    }
  }
}
