package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddStagedOrderPayment {
  private ResourceIdentifierInput payment;

  public AddStagedOrderPayment() {
  }

  public AddStagedOrderPayment(ResourceIdentifierInput payment) {
    this.payment = payment;
  }

  public ResourceIdentifierInput getPayment() {
    return payment;
  }

  public void setPayment(ResourceIdentifierInput payment) {
    this.payment = payment;
  }

  @Override
  public String toString() {
    return "AddStagedOrderPayment{payment='" + payment + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddStagedOrderPayment that = (AddStagedOrderPayment) o;
    return Objects.equals(payment, that.payment);
  }

  @Override
  public int hashCode() {
    return Objects.hash(payment);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput payment;

    public AddStagedOrderPayment build() {
      AddStagedOrderPayment result = new AddStagedOrderPayment();
      result.payment = this.payment;
      return result;
    }

    public Builder payment(ResourceIdentifierInput payment) {
      this.payment = payment;
      return this;
    }
  }
}
