package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddStoreCountry {
  private StoreCountryInput country;

  public AddStoreCountry() {
  }

  public AddStoreCountry(StoreCountryInput country) {
    this.country = country;
  }

  public StoreCountryInput getCountry() {
    return country;
  }

  public void setCountry(StoreCountryInput country) {
    this.country = country;
  }

  @Override
  public String toString() {
    return "AddStoreCountry{country='" + country + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddStoreCountry that = (AddStoreCountry) o;
    return Objects.equals(country, that.country);
  }

  @Override
  public int hashCode() {
    return Objects.hash(country);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private StoreCountryInput country;

    public AddStoreCountry build() {
      AddStoreCountry result = new AddStoreCountry();
      result.country = this.country;
      return result;
    }

    public Builder country(StoreCountryInput country) {
      this.country = country;
      return this;
    }
  }
}
