package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddStoreDistributionChannel {
  private ResourceIdentifierInput distributionChannel;

  public AddStoreDistributionChannel() {
  }

  public AddStoreDistributionChannel(ResourceIdentifierInput distributionChannel) {
    this.distributionChannel = distributionChannel;
  }

  public ResourceIdentifierInput getDistributionChannel() {
    return distributionChannel;
  }

  public void setDistributionChannel(ResourceIdentifierInput distributionChannel) {
    this.distributionChannel = distributionChannel;
  }

  @Override
  public String toString() {
    return "AddStoreDistributionChannel{distributionChannel='" + distributionChannel + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddStoreDistributionChannel that = (AddStoreDistributionChannel) o;
    return Objects.equals(distributionChannel, that.distributionChannel);
  }

  @Override
  public int hashCode() {
    return Objects.hash(distributionChannel);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput distributionChannel;

    public AddStoreDistributionChannel build() {
      AddStoreDistributionChannel result = new AddStoreDistributionChannel();
      result.distributionChannel = this.distributionChannel;
      return result;
    }

    public Builder distributionChannel(ResourceIdentifierInput distributionChannel) {
      this.distributionChannel = distributionChannel;
      return this;
    }
  }
}
