package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddStoreSupplyChannel {
  private ResourceIdentifierInput supplyChannel;

  public AddStoreSupplyChannel() {
  }

  public AddStoreSupplyChannel(ResourceIdentifierInput supplyChannel) {
    this.supplyChannel = supplyChannel;
  }

  public ResourceIdentifierInput getSupplyChannel() {
    return supplyChannel;
  }

  public void setSupplyChannel(ResourceIdentifierInput supplyChannel) {
    this.supplyChannel = supplyChannel;
  }

  @Override
  public String toString() {
    return "AddStoreSupplyChannel{supplyChannel='" + supplyChannel + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddStoreSupplyChannel that = (AddStoreSupplyChannel) o;
    return Objects.equals(supplyChannel, that.supplyChannel);
  }

  @Override
  public int hashCode() {
    return Objects.hash(supplyChannel);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput supplyChannel;

    public AddStoreSupplyChannel build() {
      AddStoreSupplyChannel result = new AddStoreSupplyChannel();
      result.supplyChannel = this.supplyChannel;
      return result;
    }

    public Builder supplyChannel(ResourceIdentifierInput supplyChannel) {
      this.supplyChannel = supplyChannel;
      return this;
    }
  }
}
