package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddTypeEnumValue {
  private String fieldName;

  private EnumValueInput value;

  public AddTypeEnumValue() {
  }

  public AddTypeEnumValue(String fieldName, EnumValueInput value) {
    this.fieldName = fieldName;
    this.value = value;
  }

  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  public EnumValueInput getValue() {
    return value;
  }

  public void setValue(EnumValueInput value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "AddTypeEnumValue{fieldName='" + fieldName + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddTypeEnumValue that = (AddTypeEnumValue) o;
    return Objects.equals(fieldName, that.fieldName) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldName, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String fieldName;

    private EnumValueInput value;

    public AddTypeEnumValue build() {
      AddTypeEnumValue result = new AddTypeEnumValue();
      result.fieldName = this.fieldName;
      result.value = this.value;
      return result;
    }

    public Builder fieldName(String fieldName) {
      this.fieldName = fieldName;
      return this;
    }

    public Builder value(EnumValueInput value) {
      this.value = value;
      return this;
    }
  }
}
