package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddTypeFieldDefinition {
  private FieldDefinitionInput fieldDefinition;

  public AddTypeFieldDefinition() {
  }

  public AddTypeFieldDefinition(FieldDefinitionInput fieldDefinition) {
    this.fieldDefinition = fieldDefinition;
  }

  public FieldDefinitionInput getFieldDefinition() {
    return fieldDefinition;
  }

  public void setFieldDefinition(FieldDefinitionInput fieldDefinition) {
    this.fieldDefinition = fieldDefinition;
  }

  @Override
  public String toString() {
    return "AddTypeFieldDefinition{fieldDefinition='" + fieldDefinition + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddTypeFieldDefinition that = (AddTypeFieldDefinition) o;
    return Objects.equals(fieldDefinition, that.fieldDefinition);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldDefinition);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private FieldDefinitionInput fieldDefinition;

    public AddTypeFieldDefinition build() {
      AddTypeFieldDefinition result = new AddTypeFieldDefinition();
      result.fieldDefinition = this.fieldDefinition;
      return result;
    }

    public Builder fieldDefinition(FieldDefinitionInput fieldDefinition) {
      this.fieldDefinition = fieldDefinition;
      return this;
    }
  }
}
