package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddTypeLocalizedEnumValue {
  private String fieldName;

  private LocalizedEnumValueInput value;

  public AddTypeLocalizedEnumValue() {
  }

  public AddTypeLocalizedEnumValue(String fieldName, LocalizedEnumValueInput value) {
    this.fieldName = fieldName;
    this.value = value;
  }

  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  public LocalizedEnumValueInput getValue() {
    return value;
  }

  public void setValue(LocalizedEnumValueInput value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "AddTypeLocalizedEnumValue{fieldName='" + fieldName + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddTypeLocalizedEnumValue that = (AddTypeLocalizedEnumValue) o;
    return Objects.equals(fieldName, that.fieldName) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldName, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String fieldName;

    private LocalizedEnumValueInput value;

    public AddTypeLocalizedEnumValue build() {
      AddTypeLocalizedEnumValue result = new AddTypeLocalizedEnumValue();
      result.fieldName = this.fieldName;
      result.value = this.value;
      return result;
    }

    public Builder fieldName(String fieldName) {
      this.fieldName = fieldName;
      return this;
    }

    public Builder value(LocalizedEnumValueInput value) {
      this.value = value;
      return this;
    }
  }
}
