package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class Applied implements com.commercetools.graphql.api.types.OrderEditResult {
  private OffsetDateTime appliedAt;

  private OrderExcerpt excerptBeforeEdit;

  private OrderExcerpt excerptAfterEdit;

  private String type;

  public Applied() {
  }

  public Applied(OffsetDateTime appliedAt, OrderExcerpt excerptBeforeEdit,
      OrderExcerpt excerptAfterEdit, String type) {
    this.appliedAt = appliedAt;
    this.excerptBeforeEdit = excerptBeforeEdit;
    this.excerptAfterEdit = excerptAfterEdit;
    this.type = type;
  }

  public OffsetDateTime getAppliedAt() {
    return appliedAt;
  }

  public void setAppliedAt(OffsetDateTime appliedAt) {
    this.appliedAt = appliedAt;
  }

  public OrderExcerpt getExcerptBeforeEdit() {
    return excerptBeforeEdit;
  }

  public void setExcerptBeforeEdit(OrderExcerpt excerptBeforeEdit) {
    this.excerptBeforeEdit = excerptBeforeEdit;
  }

  public OrderExcerpt getExcerptAfterEdit() {
    return excerptAfterEdit;
  }

  public void setExcerptAfterEdit(OrderExcerpt excerptAfterEdit) {
    this.excerptAfterEdit = excerptAfterEdit;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "Applied{appliedAt='" + appliedAt + "', excerptBeforeEdit='" + excerptBeforeEdit + "', excerptAfterEdit='" + excerptAfterEdit + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Applied that = (Applied) o;
    return Objects.equals(appliedAt, that.appliedAt) &&
        Objects.equals(excerptBeforeEdit, that.excerptBeforeEdit) &&
        Objects.equals(excerptAfterEdit, that.excerptAfterEdit) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appliedAt, excerptBeforeEdit, excerptAfterEdit, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OffsetDateTime appliedAt;

    private OrderExcerpt excerptBeforeEdit;

    private OrderExcerpt excerptAfterEdit;

    private String type;

    public Applied build() {
      Applied result = new Applied();
      result.appliedAt = this.appliedAt;
      result.excerptBeforeEdit = this.excerptBeforeEdit;
      result.excerptAfterEdit = this.excerptAfterEdit;
      result.type = this.type;
      return result;
    }

    public Builder appliedAt(OffsetDateTime appliedAt) {
      this.appliedAt = appliedAt;
      return this;
    }

    public Builder excerptBeforeEdit(OrderExcerpt excerptBeforeEdit) {
      this.excerptBeforeEdit = excerptBeforeEdit;
      return this;
    }

    public Builder excerptAfterEdit(OrderExcerpt excerptAfterEdit) {
      this.excerptAfterEdit = excerptAfterEdit;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
