package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ApprovalFlow implements com.commercetools.graphql.api.types.Versioned {
  private String status;

  private List<ApprovalFlowApproval> approvals;

  private ApprovalFlowRejection rejection;

  private Reference orderRef;

  private Order order;

  private List<ApprovalRule> rules;

  private KeyReference businessUnitRef;

  private BusinessUnit businessUnit;

  private List<RuleApprover> eligibleApprovers;

  private List<RuleApprover> pendingApprovers;

  private List<RuleApprover> currentTierPendingApprovers;

  private CustomFieldsType custom;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public ApprovalFlow() {
  }

  public ApprovalFlow(String status, List<ApprovalFlowApproval> approvals,
      ApprovalFlowRejection rejection, Reference orderRef, Order order, List<ApprovalRule> rules,
      KeyReference businessUnitRef, BusinessUnit businessUnit, List<RuleApprover> eligibleApprovers,
      List<RuleApprover> pendingApprovers, List<RuleApprover> currentTierPendingApprovers,
      CustomFieldsType custom, String id, Long version, OffsetDateTime createdAt,
      OffsetDateTime lastModifiedAt, Initiator createdBy, Initiator lastModifiedBy) {
    this.status = status;
    this.approvals = approvals;
    this.rejection = rejection;
    this.orderRef = orderRef;
    this.order = order;
    this.rules = rules;
    this.businessUnitRef = businessUnitRef;
    this.businessUnit = businessUnit;
    this.eligibleApprovers = eligibleApprovers;
    this.pendingApprovers = pendingApprovers;
    this.currentTierPendingApprovers = currentTierPendingApprovers;
    this.custom = custom;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public List<ApprovalFlowApproval> getApprovals() {
    return approvals;
  }

  public void setApprovals(List<ApprovalFlowApproval> approvals) {
    this.approvals = approvals;
  }

  public ApprovalFlowRejection getRejection() {
    return rejection;
  }

  public void setRejection(ApprovalFlowRejection rejection) {
    this.rejection = rejection;
  }

  public Reference getOrderRef() {
    return orderRef;
  }

  public void setOrderRef(Reference orderRef) {
    this.orderRef = orderRef;
  }

  public Order getOrder() {
    return order;
  }

  public void setOrder(Order order) {
    this.order = order;
  }

  public List<ApprovalRule> getRules() {
    return rules;
  }

  public void setRules(List<ApprovalRule> rules) {
    this.rules = rules;
  }

  public KeyReference getBusinessUnitRef() {
    return businessUnitRef;
  }

  public void setBusinessUnitRef(KeyReference businessUnitRef) {
    this.businessUnitRef = businessUnitRef;
  }

  public BusinessUnit getBusinessUnit() {
    return businessUnit;
  }

  public void setBusinessUnit(BusinessUnit businessUnit) {
    this.businessUnit = businessUnit;
  }

  public List<RuleApprover> getEligibleApprovers() {
    return eligibleApprovers;
  }

  public void setEligibleApprovers(List<RuleApprover> eligibleApprovers) {
    this.eligibleApprovers = eligibleApprovers;
  }

  public List<RuleApprover> getPendingApprovers() {
    return pendingApprovers;
  }

  public void setPendingApprovers(List<RuleApprover> pendingApprovers) {
    this.pendingApprovers = pendingApprovers;
  }

  public List<RuleApprover> getCurrentTierPendingApprovers() {
    return currentTierPendingApprovers;
  }

  public void setCurrentTierPendingApprovers(List<RuleApprover> currentTierPendingApprovers) {
    this.currentTierPendingApprovers = currentTierPendingApprovers;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "ApprovalFlow{status='" + status + "', approvals='" + approvals + "', rejection='" + rejection + "', orderRef='" + orderRef + "', order='" + order + "', rules='" + rules + "', businessUnitRef='" + businessUnitRef + "', businessUnit='" + businessUnit + "', eligibleApprovers='" + eligibleApprovers + "', pendingApprovers='" + pendingApprovers + "', currentTierPendingApprovers='" + currentTierPendingApprovers + "', custom='" + custom + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApprovalFlow that = (ApprovalFlow) o;
    return Objects.equals(status, that.status) &&
        Objects.equals(approvals, that.approvals) &&
        Objects.equals(rejection, that.rejection) &&
        Objects.equals(orderRef, that.orderRef) &&
        Objects.equals(order, that.order) &&
        Objects.equals(rules, that.rules) &&
        Objects.equals(businessUnitRef, that.businessUnitRef) &&
        Objects.equals(businessUnit, that.businessUnit) &&
        Objects.equals(eligibleApprovers, that.eligibleApprovers) &&
        Objects.equals(pendingApprovers, that.pendingApprovers) &&
        Objects.equals(currentTierPendingApprovers, that.currentTierPendingApprovers) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, approvals, rejection, orderRef, order, rules, businessUnitRef, businessUnit, eligibleApprovers, pendingApprovers, currentTierPendingApprovers, custom, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String status;

    private List<ApprovalFlowApproval> approvals;

    private ApprovalFlowRejection rejection;

    private Reference orderRef;

    private Order order;

    private List<ApprovalRule> rules;

    private KeyReference businessUnitRef;

    private BusinessUnit businessUnit;

    private List<RuleApprover> eligibleApprovers;

    private List<RuleApprover> pendingApprovers;

    private List<RuleApprover> currentTierPendingApprovers;

    private CustomFieldsType custom;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public ApprovalFlow build() {
      ApprovalFlow result = new ApprovalFlow();
      result.status = this.status;
      result.approvals = this.approvals;
      result.rejection = this.rejection;
      result.orderRef = this.orderRef;
      result.order = this.order;
      result.rules = this.rules;
      result.businessUnitRef = this.businessUnitRef;
      result.businessUnit = this.businessUnit;
      result.eligibleApprovers = this.eligibleApprovers;
      result.pendingApprovers = this.pendingApprovers;
      result.currentTierPendingApprovers = this.currentTierPendingApprovers;
      result.custom = this.custom;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder status(String status) {
      this.status = status;
      return this;
    }

    public Builder approvals(List<ApprovalFlowApproval> approvals) {
      this.approvals = approvals;
      return this;
    }

    public Builder rejection(ApprovalFlowRejection rejection) {
      this.rejection = rejection;
      return this;
    }

    public Builder orderRef(Reference orderRef) {
      this.orderRef = orderRef;
      return this;
    }

    public Builder order(Order order) {
      this.order = order;
      return this;
    }

    public Builder rules(List<ApprovalRule> rules) {
      this.rules = rules;
      return this;
    }

    public Builder businessUnitRef(KeyReference businessUnitRef) {
      this.businessUnitRef = businessUnitRef;
      return this;
    }

    public Builder businessUnit(BusinessUnit businessUnit) {
      this.businessUnit = businessUnit;
      return this;
    }

    public Builder eligibleApprovers(List<RuleApprover> eligibleApprovers) {
      this.eligibleApprovers = eligibleApprovers;
      return this;
    }

    public Builder pendingApprovers(List<RuleApprover> pendingApprovers) {
      this.pendingApprovers = pendingApprovers;
      return this;
    }

    public Builder currentTierPendingApprovers(List<RuleApprover> currentTierPendingApprovers) {
      this.currentTierPendingApprovers = currentTierPendingApprovers;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
