package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class ApprovalFlowApproval {
  private Associate approver;

  private OffsetDateTime approvedAt;

  public ApprovalFlowApproval() {
  }

  public ApprovalFlowApproval(Associate approver, OffsetDateTime approvedAt) {
    this.approver = approver;
    this.approvedAt = approvedAt;
  }

  public Associate getApprover() {
    return approver;
  }

  public void setApprover(Associate approver) {
    this.approver = approver;
  }

  public OffsetDateTime getApprovedAt() {
    return approvedAt;
  }

  public void setApprovedAt(OffsetDateTime approvedAt) {
    this.approvedAt = approvedAt;
  }

  @Override
  public String toString() {
    return "ApprovalFlowApproval{approver='" + approver + "', approvedAt='" + approvedAt + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApprovalFlowApproval that = (ApprovalFlowApproval) o;
    return Objects.equals(approver, that.approver) &&
        Objects.equals(approvedAt, that.approvedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(approver, approvedAt);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Associate approver;

    private OffsetDateTime approvedAt;

    public ApprovalFlowApproval build() {
      ApprovalFlowApproval result = new ApprovalFlowApproval();
      result.approver = this.approver;
      result.approvedAt = this.approvedAt;
      return result;
    }

    public Builder approver(Associate approver) {
      this.approver = approver;
      return this;
    }

    public Builder approvedAt(OffsetDateTime approvedAt) {
      this.approvedAt = approvedAt;
      return this;
    }
  }
}
