package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ApprovalFlowCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private ApprovalFlow approvalFlow;

  private String type;

  public ApprovalFlowCreated() {
  }

  public ApprovalFlowCreated(ApprovalFlow approvalFlow, String type) {
    this.approvalFlow = approvalFlow;
    this.type = type;
  }

  public ApprovalFlow getApprovalFlow() {
    return approvalFlow;
  }

  public void setApprovalFlow(ApprovalFlow approvalFlow) {
    this.approvalFlow = approvalFlow;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ApprovalFlowCreated{approvalFlow='" + approvalFlow + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApprovalFlowCreated that = (ApprovalFlowCreated) o;
    return Objects.equals(approvalFlow, that.approvalFlow) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(approvalFlow, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ApprovalFlow approvalFlow;

    private String type;

    public ApprovalFlowCreated build() {
      ApprovalFlowCreated result = new ApprovalFlowCreated();
      result.approvalFlow = this.approvalFlow;
      result.type = this.type;
      return result;
    }

    public Builder approvalFlow(ApprovalFlow approvalFlow) {
      this.approvalFlow = approvalFlow;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
