package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ApprovalFlowRejected implements com.commercetools.graphql.api.types.MessagePayload {
  private String rejectionReason;

  private Customer associate;

  private Order order;

  private Reference associateRef;

  private Reference orderRef;

  private String type;

  public ApprovalFlowRejected() {
  }

  public ApprovalFlowRejected(String rejectionReason, Customer associate, Order order,
      Reference associateRef, Reference orderRef, String type) {
    this.rejectionReason = rejectionReason;
    this.associate = associate;
    this.order = order;
    this.associateRef = associateRef;
    this.orderRef = orderRef;
    this.type = type;
  }

  public String getRejectionReason() {
    return rejectionReason;
  }

  public void setRejectionReason(String rejectionReason) {
    this.rejectionReason = rejectionReason;
  }

  public Customer getAssociate() {
    return associate;
  }

  public void setAssociate(Customer associate) {
    this.associate = associate;
  }

  public Order getOrder() {
    return order;
  }

  public void setOrder(Order order) {
    this.order = order;
  }

  public Reference getAssociateRef() {
    return associateRef;
  }

  public void setAssociateRef(Reference associateRef) {
    this.associateRef = associateRef;
  }

  public Reference getOrderRef() {
    return orderRef;
  }

  public void setOrderRef(Reference orderRef) {
    this.orderRef = orderRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ApprovalFlowRejected{rejectionReason='" + rejectionReason + "', associate='" + associate + "', order='" + order + "', associateRef='" + associateRef + "', orderRef='" + orderRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApprovalFlowRejected that = (ApprovalFlowRejected) o;
    return Objects.equals(rejectionReason, that.rejectionReason) &&
        Objects.equals(associate, that.associate) &&
        Objects.equals(order, that.order) &&
        Objects.equals(associateRef, that.associateRef) &&
        Objects.equals(orderRef, that.orderRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rejectionReason, associate, order, associateRef, orderRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String rejectionReason;

    private Customer associate;

    private Order order;

    private Reference associateRef;

    private Reference orderRef;

    private String type;

    public ApprovalFlowRejected build() {
      ApprovalFlowRejected result = new ApprovalFlowRejected();
      result.rejectionReason = this.rejectionReason;
      result.associate = this.associate;
      result.order = this.order;
      result.associateRef = this.associateRef;
      result.orderRef = this.orderRef;
      result.type = this.type;
      return result;
    }

    public Builder rejectionReason(String rejectionReason) {
      this.rejectionReason = rejectionReason;
      return this;
    }

    public Builder associate(Customer associate) {
      this.associate = associate;
      return this;
    }

    public Builder order(Order order) {
      this.order = order;
      return this;
    }

    public Builder associateRef(Reference associateRef) {
      this.associateRef = associateRef;
      return this;
    }

    public Builder orderRef(Reference orderRef) {
      this.orderRef = orderRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
