package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class ApprovalFlowRejection {
  private Associate rejecter;

  private OffsetDateTime rejectedAt;

  private String reason;

  public ApprovalFlowRejection() {
  }

  public ApprovalFlowRejection(Associate rejecter, OffsetDateTime rejectedAt, String reason) {
    this.rejecter = rejecter;
    this.rejectedAt = rejectedAt;
    this.reason = reason;
  }

  public Associate getRejecter() {
    return rejecter;
  }

  public void setRejecter(Associate rejecter) {
    this.rejecter = rejecter;
  }

  public OffsetDateTime getRejectedAt() {
    return rejectedAt;
  }

  public void setRejectedAt(OffsetDateTime rejectedAt) {
    this.rejectedAt = rejectedAt;
  }

  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  @Override
  public String toString() {
    return "ApprovalFlowRejection{rejecter='" + rejecter + "', rejectedAt='" + rejectedAt + "', reason='" + reason + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApprovalFlowRejection that = (ApprovalFlowRejection) o;
    return Objects.equals(rejecter, that.rejecter) &&
        Objects.equals(rejectedAt, that.rejectedAt) &&
        Objects.equals(reason, that.reason);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rejecter, rejectedAt, reason);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Associate rejecter;

    private OffsetDateTime rejectedAt;

    private String reason;

    public ApprovalFlowRejection build() {
      ApprovalFlowRejection result = new ApprovalFlowRejection();
      result.rejecter = this.rejecter;
      result.rejectedAt = this.rejectedAt;
      result.reason = this.reason;
      return result;
    }

    public Builder rejecter(Associate rejecter) {
      this.rejecter = rejecter;
      return this;
    }

    public Builder rejectedAt(OffsetDateTime rejectedAt) {
      this.rejectedAt = rejectedAt;
      return this;
    }

    public Builder reason(String reason) {
      this.reason = reason;
      return this;
    }
  }
}
