package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ApprovalRuleCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private ApprovalRule approvalRule;

  private String type;

  public ApprovalRuleCreated() {
  }

  public ApprovalRuleCreated(ApprovalRule approvalRule, String type) {
    this.approvalRule = approvalRule;
    this.type = type;
  }

  public ApprovalRule getApprovalRule() {
    return approvalRule;
  }

  public void setApprovalRule(ApprovalRule approvalRule) {
    this.approvalRule = approvalRule;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ApprovalRuleCreated{approvalRule='" + approvalRule + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApprovalRuleCreated that = (ApprovalRuleCreated) o;
    return Objects.equals(approvalRule, that.approvalRule) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(approvalRule, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ApprovalRule approvalRule;

    private String type;

    public ApprovalRuleCreated build() {
      ApprovalRuleCreated result = new ApprovalRuleCreated();
      result.approvalRule = this.approvalRule;
      result.type = this.type;
      return result;
    }

    public Builder approvalRule(ApprovalRule approvalRule) {
      this.approvalRule = approvalRule;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
