package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ApprovalRuleDescriptionSet implements com.commercetools.graphql.api.types.MessagePayload {
  private String oldDescription;

  private String description;

  private String type;

  public ApprovalRuleDescriptionSet() {
  }

  public ApprovalRuleDescriptionSet(String oldDescription, String description, String type) {
    this.oldDescription = oldDescription;
    this.description = description;
    this.type = type;
  }

  public String getOldDescription() {
    return oldDescription;
  }

  public void setOldDescription(String oldDescription) {
    this.oldDescription = oldDescription;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ApprovalRuleDescriptionSet{oldDescription='" + oldDescription + "', description='" + description + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApprovalRuleDescriptionSet that = (ApprovalRuleDescriptionSet) o;
    return Objects.equals(oldDescription, that.oldDescription) &&
        Objects.equals(description, that.description) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oldDescription, description, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String oldDescription;

    private String description;

    private String type;

    public ApprovalRuleDescriptionSet build() {
      ApprovalRuleDescriptionSet result = new ApprovalRuleDescriptionSet();
      result.oldDescription = this.oldDescription;
      result.description = this.description;
      result.type = this.type;
      return result;
    }

    public Builder oldDescription(String oldDescription) {
      this.oldDescription = oldDescription;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
