package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ApprovalRuleDraft {
  private String key;

  private String name;

  private String description;

  private ApprovalRuleStatus status;

  private String predicate;

  private ApproverHierarchyDraft approvers;

  private List<RuleRequesterDraft> requesters;

  public ApprovalRuleDraft() {
  }

  public ApprovalRuleDraft(String key, String name, String description, ApprovalRuleStatus status,
      String predicate, ApproverHierarchyDraft approvers, List<RuleRequesterDraft> requesters) {
    this.key = key;
    this.name = name;
    this.description = description;
    this.status = status;
    this.predicate = predicate;
    this.approvers = approvers;
    this.requesters = requesters;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public ApprovalRuleStatus getStatus() {
    return status;
  }

  public void setStatus(ApprovalRuleStatus status) {
    this.status = status;
  }

  public String getPredicate() {
    return predicate;
  }

  public void setPredicate(String predicate) {
    this.predicate = predicate;
  }

  public ApproverHierarchyDraft getApprovers() {
    return approvers;
  }

  public void setApprovers(ApproverHierarchyDraft approvers) {
    this.approvers = approvers;
  }

  public List<RuleRequesterDraft> getRequesters() {
    return requesters;
  }

  public void setRequesters(List<RuleRequesterDraft> requesters) {
    this.requesters = requesters;
  }

  @Override
  public String toString() {
    return "ApprovalRuleDraft{key='" + key + "', name='" + name + "', description='" + description + "', status='" + status + "', predicate='" + predicate + "', approvers='" + approvers + "', requesters='" + requesters + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApprovalRuleDraft that = (ApprovalRuleDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(name, that.name) &&
        Objects.equals(description, that.description) &&
        Objects.equals(status, that.status) &&
        Objects.equals(predicate, that.predicate) &&
        Objects.equals(approvers, that.approvers) &&
        Objects.equals(requesters, that.requesters);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, name, description, status, predicate, approvers, requesters);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String name;

    private String description;

    private ApprovalRuleStatus status;

    private String predicate;

    private ApproverHierarchyDraft approvers;

    private List<RuleRequesterDraft> requesters;

    public ApprovalRuleDraft build() {
      ApprovalRuleDraft result = new ApprovalRuleDraft();
      result.key = this.key;
      result.name = this.name;
      result.description = this.description;
      result.status = this.status;
      result.predicate = this.predicate;
      result.approvers = this.approvers;
      result.requesters = this.requesters;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder status(ApprovalRuleStatus status) {
      this.status = status;
      return this;
    }

    public Builder predicate(String predicate) {
      this.predicate = predicate;
      return this;
    }

    public Builder approvers(ApproverHierarchyDraft approvers) {
      this.approvers = approvers;
      return this;
    }

    public Builder requesters(List<RuleRequesterDraft> requesters) {
      this.requesters = requesters;
      return this;
    }
  }
}
