package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ApprovalRuleNameSet implements com.commercetools.graphql.api.types.MessagePayload {
  private String oldName;

  private String name;

  private String type;

  public ApprovalRuleNameSet() {
  }

  public ApprovalRuleNameSet(String oldName, String name, String type) {
    this.oldName = oldName;
    this.name = name;
    this.type = type;
  }

  public String getOldName() {
    return oldName;
  }

  public void setOldName(String oldName) {
    this.oldName = oldName;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ApprovalRuleNameSet{oldName='" + oldName + "', name='" + name + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApprovalRuleNameSet that = (ApprovalRuleNameSet) o;
    return Objects.equals(oldName, that.oldName) &&
        Objects.equals(name, that.name) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oldName, name, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String oldName;

    private String name;

    private String type;

    public ApprovalRuleNameSet build() {
      ApprovalRuleNameSet result = new ApprovalRuleNameSet();
      result.oldName = this.oldName;
      result.name = this.name;
      result.type = this.type;
      return result;
    }

    public Builder oldName(String oldName) {
      this.oldName = oldName;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
