package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ApproverConjunction {
  private List<ApproverDisjunction> and;

  public ApproverConjunction() {
  }

  public ApproverConjunction(List<ApproverDisjunction> and) {
    this.and = and;
  }

  public List<ApproverDisjunction> getAnd() {
    return and;
  }

  public void setAnd(List<ApproverDisjunction> and) {
    this.and = and;
  }

  @Override
  public String toString() {
    return "ApproverConjunction{and='" + and + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApproverConjunction that = (ApproverConjunction) o;
    return Objects.equals(and, that.and);
  }

  @Override
  public int hashCode() {
    return Objects.hash(and);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ApproverDisjunction> and;

    public ApproverConjunction build() {
      ApproverConjunction result = new ApproverConjunction();
      result.and = this.and;
      return result;
    }

    public Builder and(List<ApproverDisjunction> and) {
      this.and = and;
      return this;
    }
  }
}
