package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ApproverDisjunctionDraft {
  private List<RuleApproverDraft> or;

  public ApproverDisjunctionDraft() {
  }

  public ApproverDisjunctionDraft(List<RuleApproverDraft> or) {
    this.or = or;
  }

  public List<RuleApproverDraft> getOr() {
    return or;
  }

  public void setOr(List<RuleApproverDraft> or) {
    this.or = or;
  }

  @Override
  public String toString() {
    return "ApproverDisjunctionDraft{or='" + or + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApproverDisjunctionDraft that = (ApproverDisjunctionDraft) o;
    return Objects.equals(or, that.or);
  }

  @Override
  public int hashCode() {
    return Objects.hash(or);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<RuleApproverDraft> or;

    public ApproverDisjunctionDraft build() {
      ApproverDisjunctionDraft result = new ApproverDisjunctionDraft();
      result.or = this.or;
      return result;
    }

    public Builder or(List<RuleApproverDraft> or) {
      this.or = or;
      return this;
    }
  }
}
