package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AssetDimensions {
  private Integer width;

  private Integer height;

  public AssetDimensions() {
  }

  public AssetDimensions(Integer width, Integer height) {
    this.width = width;
    this.height = height;
  }

  public Integer getWidth() {
    return width;
  }

  public void setWidth(Integer width) {
    this.width = width;
  }

  public Integer getHeight() {
    return height;
  }

  public void setHeight(Integer height) {
    this.height = height;
  }

  @Override
  public String toString() {
    return "AssetDimensions{width='" + width + "', height='" + height + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AssetDimensions that = (AssetDimensions) o;
    return Objects.equals(width, that.width) &&
        Objects.equals(height, that.height);
  }

  @Override
  public int hashCode() {
    return Objects.hash(width, height);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer width;

    private Integer height;

    public AssetDimensions build() {
      AssetDimensions result = new AssetDimensions();
      result.width = this.width;
      result.height = this.height;
      return result;
    }

    public Builder width(Integer width) {
      this.width = width;
      return this;
    }

    public Builder height(Integer height) {
      this.height = height;
      return this;
    }
  }
}
