package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AssetSourceInput {
  private String uri;

  private String key;

  private AssetDimensionsInput dimensions;

  private String contentType;

  public AssetSourceInput() {
  }

  public AssetSourceInput(String uri, String key, AssetDimensionsInput dimensions,
      String contentType) {
    this.uri = uri;
    this.key = key;
    this.dimensions = dimensions;
    this.contentType = contentType;
  }

  public String getUri() {
    return uri;
  }

  public void setUri(String uri) {
    this.uri = uri;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public AssetDimensionsInput getDimensions() {
    return dimensions;
  }

  public void setDimensions(AssetDimensionsInput dimensions) {
    this.dimensions = dimensions;
  }

  public String getContentType() {
    return contentType;
  }

  public void setContentType(String contentType) {
    this.contentType = contentType;
  }

  @Override
  public String toString() {
    return "AssetSourceInput{uri='" + uri + "', key='" + key + "', dimensions='" + dimensions + "', contentType='" + contentType + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AssetSourceInput that = (AssetSourceInput) o;
    return Objects.equals(uri, that.uri) &&
        Objects.equals(key, that.key) &&
        Objects.equals(dimensions, that.dimensions) &&
        Objects.equals(contentType, that.contentType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(uri, key, dimensions, contentType);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String uri;

    private String key;

    private AssetDimensionsInput dimensions;

    private String contentType;

    public AssetSourceInput build() {
      AssetSourceInput result = new AssetSourceInput();
      result.uri = this.uri;
      result.key = this.key;
      result.dimensions = this.dimensions;
      result.contentType = this.contentType;
      return result;
    }

    public Builder uri(String uri) {
      this.uri = uri;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder dimensions(AssetDimensionsInput dimensions) {
      this.dimensions = dimensions;
      return this;
    }

    public Builder contentType(String contentType) {
      this.contentType = contentType;
      return this;
    }
  }
}
