package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class Associate {
  private List<AssociateRoleAssignment> associateRoleAssignments;

  private Reference customerRef;

  private Customer customer;

  public Associate() {
  }

  public Associate(List<AssociateRoleAssignment> associateRoleAssignments, Reference customerRef,
      Customer customer) {
    this.associateRoleAssignments = associateRoleAssignments;
    this.customerRef = customerRef;
    this.customer = customer;
  }

  public List<AssociateRoleAssignment> getAssociateRoleAssignments() {
    return associateRoleAssignments;
  }

  public void setAssociateRoleAssignments(List<AssociateRoleAssignment> associateRoleAssignments) {
    this.associateRoleAssignments = associateRoleAssignments;
  }

  public Reference getCustomerRef() {
    return customerRef;
  }

  public void setCustomerRef(Reference customerRef) {
    this.customerRef = customerRef;
  }

  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer customer) {
    this.customer = customer;
  }

  @Override
  public String toString() {
    return "Associate{associateRoleAssignments='" + associateRoleAssignments + "', customerRef='" + customerRef + "', customer='" + customer + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Associate that = (Associate) o;
    return Objects.equals(associateRoleAssignments, that.associateRoleAssignments) &&
        Objects.equals(customerRef, that.customerRef) &&
        Objects.equals(customer, that.customer);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associateRoleAssignments, customerRef, customer);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<AssociateRoleAssignment> associateRoleAssignments;

    private Reference customerRef;

    private Customer customer;

    public Associate build() {
      Associate result = new Associate();
      result.associateRoleAssignments = this.associateRoleAssignments;
      result.customerRef = this.customerRef;
      result.customer = this.customer;
      return result;
    }

    public Builder associateRoleAssignments(
        List<AssociateRoleAssignment> associateRoleAssignments) {
      this.associateRoleAssignments = associateRoleAssignments;
      return this;
    }

    public Builder customerRef(Reference customerRef) {
      this.customerRef = customerRef;
      return this;
    }

    public Builder customer(Customer customer) {
      this.customer = customer;
      return this;
    }
  }
}
