package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AssociateRoleAssignmentDraft {
  private ResourceIdentifierInput associateRole;

  private AssociateInheritanceMode inheritance;

  public AssociateRoleAssignmentDraft() {
  }

  public AssociateRoleAssignmentDraft(ResourceIdentifierInput associateRole,
      AssociateInheritanceMode inheritance) {
    this.associateRole = associateRole;
    this.inheritance = inheritance;
  }

  public ResourceIdentifierInput getAssociateRole() {
    return associateRole;
  }

  public void setAssociateRole(ResourceIdentifierInput associateRole) {
    this.associateRole = associateRole;
  }

  public AssociateInheritanceMode getInheritance() {
    return inheritance;
  }

  public void setInheritance(AssociateInheritanceMode inheritance) {
    this.inheritance = inheritance;
  }

  @Override
  public String toString() {
    return "AssociateRoleAssignmentDraft{associateRole='" + associateRole + "', inheritance='" + inheritance + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AssociateRoleAssignmentDraft that = (AssociateRoleAssignmentDraft) o;
    return Objects.equals(associateRole, that.associateRole) &&
        Objects.equals(inheritance, that.inheritance);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associateRole, inheritance);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput associateRole;

    private AssociateInheritanceMode inheritance;

    public AssociateRoleAssignmentDraft build() {
      AssociateRoleAssignmentDraft result = new AssociateRoleAssignmentDraft();
      result.associateRole = this.associateRole;
      result.inheritance = this.inheritance;
      return result;
    }

    public Builder associateRole(ResourceIdentifierInput associateRole) {
      this.associateRole = associateRole;
      return this;
    }

    public Builder inheritance(AssociateInheritanceMode inheritance) {
      this.inheritance = inheritance;
      return this;
    }
  }
}
