package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AssociateRoleBuyerAssignableChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private Boolean buyerAssignable;

  private String type;

  public AssociateRoleBuyerAssignableChanged() {
  }

  public AssociateRoleBuyerAssignableChanged(Boolean buyerAssignable, String type) {
    this.buyerAssignable = buyerAssignable;
    this.type = type;
  }

  public Boolean getBuyerAssignable() {
    return buyerAssignable;
  }

  public void setBuyerAssignable(Boolean buyerAssignable) {
    this.buyerAssignable = buyerAssignable;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "AssociateRoleBuyerAssignableChanged{buyerAssignable='" + buyerAssignable + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AssociateRoleBuyerAssignableChanged that = (AssociateRoleBuyerAssignableChanged) o;
    return Objects.equals(buyerAssignable, that.buyerAssignable) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(buyerAssignable, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Boolean buyerAssignable;

    private String type;

    public AssociateRoleBuyerAssignableChanged build() {
      AssociateRoleBuyerAssignableChanged result = new AssociateRoleBuyerAssignableChanged();
      result.buyerAssignable = this.buyerAssignable;
      result.type = this.type;
      return result;
    }

    public Builder buyerAssignable(Boolean buyerAssignable) {
      this.buyerAssignable = buyerAssignable;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
