package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AssociateRoleCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private AssociateRole associateRole;

  private String type;

  public AssociateRoleCreated() {
  }

  public AssociateRoleCreated(AssociateRole associateRole, String type) {
    this.associateRole = associateRole;
    this.type = type;
  }

  public AssociateRole getAssociateRole() {
    return associateRole;
  }

  public void setAssociateRole(AssociateRole associateRole) {
    this.associateRole = associateRole;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "AssociateRoleCreated{associateRole='" + associateRole + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AssociateRoleCreated that = (AssociateRoleCreated) o;
    return Objects.equals(associateRole, that.associateRole) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associateRole, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AssociateRole associateRole;

    private String type;

    public AssociateRoleCreated build() {
      AssociateRoleCreated result = new AssociateRoleCreated();
      result.associateRole = this.associateRole;
      result.type = this.type;
      return result;
    }

    public Builder associateRole(AssociateRole associateRole) {
      this.associateRole = associateRole;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
