package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class AssociateRoleDraft {
  private String key;

  private String name;

  private Boolean buyerAssignable;

  private List<Permission> permissions;

  private CustomFieldsDraft custom;

  public AssociateRoleDraft() {
  }

  public AssociateRoleDraft(String key, String name, Boolean buyerAssignable,
      List<Permission> permissions, CustomFieldsDraft custom) {
    this.key = key;
    this.name = name;
    this.buyerAssignable = buyerAssignable;
    this.permissions = permissions;
    this.custom = custom;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Boolean getBuyerAssignable() {
    return buyerAssignable;
  }

  public void setBuyerAssignable(Boolean buyerAssignable) {
    this.buyerAssignable = buyerAssignable;
  }

  public List<Permission> getPermissions() {
    return permissions;
  }

  public void setPermissions(List<Permission> permissions) {
    this.permissions = permissions;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "AssociateRoleDraft{key='" + key + "', name='" + name + "', buyerAssignable='" + buyerAssignable + "', permissions='" + permissions + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AssociateRoleDraft that = (AssociateRoleDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(name, that.name) &&
        Objects.equals(buyerAssignable, that.buyerAssignable) &&
        Objects.equals(permissions, that.permissions) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, name, buyerAssignable, permissions, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String name;

    private Boolean buyerAssignable;

    private List<Permission> permissions;

    private CustomFieldsDraft custom;

    public AssociateRoleDraft build() {
      AssociateRoleDraft result = new AssociateRoleDraft();
      result.key = this.key;
      result.name = this.name;
      result.buyerAssignable = this.buyerAssignable;
      result.permissions = this.permissions;
      result.custom = this.custom;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder buyerAssignable(Boolean buyerAssignable) {
      this.buyerAssignable = buyerAssignable;
      return this;
    }

    public Builder permissions(List<Permission> permissions) {
      this.permissions = permissions;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
