package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AssociateRolePermissionsSet implements com.commercetools.graphql.api.types.MessagePayload {
  private List<Permission> permissions;

  private String type;

  public AssociateRolePermissionsSet() {
  }

  public AssociateRolePermissionsSet(List<Permission> permissions, String type) {
    this.permissions = permissions;
    this.type = type;
  }

  public List<Permission> getPermissions() {
    return permissions;
  }

  public void setPermissions(List<Permission> permissions) {
    this.permissions = permissions;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "AssociateRolePermissionsSet{permissions='" + permissions + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AssociateRolePermissionsSet that = (AssociateRolePermissionsSet) o;
    return Objects.equals(permissions, that.permissions) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(permissions, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<Permission> permissions;

    private String type;

    public AssociateRolePermissionsSet build() {
      AssociateRolePermissionsSet result = new AssociateRolePermissionsSet();
      result.permissions = this.permissions;
      result.type = this.type;
      return result;
    }

    public Builder permissions(List<Permission> permissions) {
      this.permissions = permissions;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
