package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AssociateRoleUpdateAction {
  private AddAssociateRolePermission addPermission;

  private ChangeAssociateRoleBuyerAssignable changeBuyerAssignable;

  private RemoveAssociateRolePermission removePermission;

  private SetAssociateRoleCustomField setCustomField;

  private SetAssociateRoleCustomType setCustomType;

  private SetAssociateRoleName setName;

  private SetAssociateRolePermissions setPermissions;

  public AssociateRoleUpdateAction() {
  }

  public AssociateRoleUpdateAction(AddAssociateRolePermission addPermission,
      ChangeAssociateRoleBuyerAssignable changeBuyerAssignable,
      RemoveAssociateRolePermission removePermission, SetAssociateRoleCustomField setCustomField,
      SetAssociateRoleCustomType setCustomType, SetAssociateRoleName setName,
      SetAssociateRolePermissions setPermissions) {
    this.addPermission = addPermission;
    this.changeBuyerAssignable = changeBuyerAssignable;
    this.removePermission = removePermission;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setName = setName;
    this.setPermissions = setPermissions;
  }

  public AddAssociateRolePermission getAddPermission() {
    return addPermission;
  }

  public void setAddPermission(AddAssociateRolePermission addPermission) {
    this.addPermission = addPermission;
  }

  public ChangeAssociateRoleBuyerAssignable getChangeBuyerAssignable() {
    return changeBuyerAssignable;
  }

  public void setChangeBuyerAssignable(ChangeAssociateRoleBuyerAssignable changeBuyerAssignable) {
    this.changeBuyerAssignable = changeBuyerAssignable;
  }

  public RemoveAssociateRolePermission getRemovePermission() {
    return removePermission;
  }

  public void setRemovePermission(RemoveAssociateRolePermission removePermission) {
    this.removePermission = removePermission;
  }

  public SetAssociateRoleCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetAssociateRoleCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetAssociateRoleCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetAssociateRoleCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetAssociateRoleName getSetName() {
    return setName;
  }

  public void setSetName(SetAssociateRoleName setName) {
    this.setName = setName;
  }

  public SetAssociateRolePermissions getSetPermissions() {
    return setPermissions;
  }

  public void setSetPermissions(SetAssociateRolePermissions setPermissions) {
    this.setPermissions = setPermissions;
  }

  @Override
  public String toString() {
    return "AssociateRoleUpdateAction{addPermission='" + addPermission + "', changeBuyerAssignable='" + changeBuyerAssignable + "', removePermission='" + removePermission + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setName='" + setName + "', setPermissions='" + setPermissions + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AssociateRoleUpdateAction that = (AssociateRoleUpdateAction) o;
    return Objects.equals(addPermission, that.addPermission) &&
        Objects.equals(changeBuyerAssignable, that.changeBuyerAssignable) &&
        Objects.equals(removePermission, that.removePermission) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setName, that.setName) &&
        Objects.equals(setPermissions, that.setPermissions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addPermission, changeBuyerAssignable, removePermission, setCustomField, setCustomType, setName, setPermissions);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddAssociateRolePermission addPermission;

    private ChangeAssociateRoleBuyerAssignable changeBuyerAssignable;

    private RemoveAssociateRolePermission removePermission;

    private SetAssociateRoleCustomField setCustomField;

    private SetAssociateRoleCustomType setCustomType;

    private SetAssociateRoleName setName;

    private SetAssociateRolePermissions setPermissions;

    public AssociateRoleUpdateAction build() {
      AssociateRoleUpdateAction result = new AssociateRoleUpdateAction();
      result.addPermission = this.addPermission;
      result.changeBuyerAssignable = this.changeBuyerAssignable;
      result.removePermission = this.removePermission;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setName = this.setName;
      result.setPermissions = this.setPermissions;
      return result;
    }

    public Builder addPermission(AddAssociateRolePermission addPermission) {
      this.addPermission = addPermission;
      return this;
    }

    public Builder changeBuyerAssignable(ChangeAssociateRoleBuyerAssignable changeBuyerAssignable) {
      this.changeBuyerAssignable = changeBuyerAssignable;
      return this;
    }

    public Builder removePermission(RemoveAssociateRolePermission removePermission) {
      this.removePermission = removePermission;
      return this;
    }

    public Builder setCustomField(SetAssociateRoleCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetAssociateRoleCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setName(SetAssociateRoleName setName) {
      this.setName = setName;
      return this;
    }

    public Builder setPermissions(SetAssociateRolePermissions setPermissions) {
      this.setPermissions = setPermissions;
      return this;
    }
  }
}
