package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = BooleanAttribute.class, name = "BooleanAttribute"),
    @JsonSubTypes.Type(value = DateAttribute.class, name = "DateAttribute"),
    @JsonSubTypes.Type(value = DateTimeAttribute.class, name = "DateTimeAttribute"),
    @JsonSubTypes.Type(value = EnumAttribute.class, name = "EnumAttribute"),
    @JsonSubTypes.Type(value = LocalizedEnumAttribute.class, name = "LocalizedEnumAttribute"),
    @JsonSubTypes.Type(value = LocalizedStringAttribute.class, name = "LocalizedStringAttribute"),
    @JsonSubTypes.Type(value = MoneyAttribute.class, name = "MoneyAttribute"),
    @JsonSubTypes.Type(value = NumberAttribute.class, name = "NumberAttribute"),
    @JsonSubTypes.Type(value = ReferenceAttribute.class, name = "ReferenceAttribute"),
    @JsonSubTypes.Type(value = StringAttribute.class, name = "StringAttribute"),
    @JsonSubTypes.Type(value = TimeAttribute.class, name = "TimeAttribute")
})
public interface Attribute {
  String getName();

  void setName(String name);
}
