package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class AttributeDefinition {
  private AttributeDefinitionType type;

  private String name;

  private String label;

  private Boolean isRequired;

  private AttributeConstraint attributeConstraint;

  private String inputTip;

  private TextInputHint inputHint;

  private Boolean isSearchable;

  private List<LocalizedString> labelAllLocales;

  private List<LocalizedString> inputTipAllLocales;

  public AttributeDefinition() {
  }

  public AttributeDefinition(AttributeDefinitionType type, String name, String label,
      Boolean isRequired, AttributeConstraint attributeConstraint, String inputTip,
      TextInputHint inputHint, Boolean isSearchable, List<LocalizedString> labelAllLocales,
      List<LocalizedString> inputTipAllLocales) {
    this.type = type;
    this.name = name;
    this.label = label;
    this.isRequired = isRequired;
    this.attributeConstraint = attributeConstraint;
    this.inputTip = inputTip;
    this.inputHint = inputHint;
    this.isSearchable = isSearchable;
    this.labelAllLocales = labelAllLocales;
    this.inputTipAllLocales = inputTipAllLocales;
  }

  public AttributeDefinitionType getType() {
    return type;
  }

  public void setType(AttributeDefinitionType type) {
    this.type = type;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  public Boolean getIsRequired() {
    return isRequired;
  }

  public void setIsRequired(Boolean isRequired) {
    this.isRequired = isRequired;
  }

  public AttributeConstraint getAttributeConstraint() {
    return attributeConstraint;
  }

  public void setAttributeConstraint(AttributeConstraint attributeConstraint) {
    this.attributeConstraint = attributeConstraint;
  }

  public String getInputTip() {
    return inputTip;
  }

  public void setInputTip(String inputTip) {
    this.inputTip = inputTip;
  }

  public TextInputHint getInputHint() {
    return inputHint;
  }

  public void setInputHint(TextInputHint inputHint) {
    this.inputHint = inputHint;
  }

  public Boolean getIsSearchable() {
    return isSearchable;
  }

  public void setIsSearchable(Boolean isSearchable) {
    this.isSearchable = isSearchable;
  }

  public List<LocalizedString> getLabelAllLocales() {
    return labelAllLocales;
  }

  public void setLabelAllLocales(List<LocalizedString> labelAllLocales) {
    this.labelAllLocales = labelAllLocales;
  }

  public List<LocalizedString> getInputTipAllLocales() {
    return inputTipAllLocales;
  }

  public void setInputTipAllLocales(List<LocalizedString> inputTipAllLocales) {
    this.inputTipAllLocales = inputTipAllLocales;
  }

  @Override
  public String toString() {
    return "AttributeDefinition{type='" + type + "', name='" + name + "', label='" + label + "', isRequired='" + isRequired + "', attributeConstraint='" + attributeConstraint + "', inputTip='" + inputTip + "', inputHint='" + inputHint + "', isSearchable='" + isSearchable + "', labelAllLocales='" + labelAllLocales + "', inputTipAllLocales='" + inputTipAllLocales + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AttributeDefinition that = (AttributeDefinition) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(name, that.name) &&
        Objects.equals(label, that.label) &&
        Objects.equals(isRequired, that.isRequired) &&
        Objects.equals(attributeConstraint, that.attributeConstraint) &&
        Objects.equals(inputTip, that.inputTip) &&
        Objects.equals(inputHint, that.inputHint) &&
        Objects.equals(isSearchable, that.isSearchable) &&
        Objects.equals(labelAllLocales, that.labelAllLocales) &&
        Objects.equals(inputTipAllLocales, that.inputTipAllLocales);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, name, label, isRequired, attributeConstraint, inputTip, inputHint, isSearchable, labelAllLocales, inputTipAllLocales);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AttributeDefinitionType type;

    private String name;

    private String label;

    private Boolean isRequired;

    private AttributeConstraint attributeConstraint;

    private String inputTip;

    private TextInputHint inputHint;

    private Boolean isSearchable;

    private List<LocalizedString> labelAllLocales;

    private List<LocalizedString> inputTipAllLocales;

    public AttributeDefinition build() {
      AttributeDefinition result = new AttributeDefinition();
      result.type = this.type;
      result.name = this.name;
      result.label = this.label;
      result.isRequired = this.isRequired;
      result.attributeConstraint = this.attributeConstraint;
      result.inputTip = this.inputTip;
      result.inputHint = this.inputHint;
      result.isSearchable = this.isSearchable;
      result.labelAllLocales = this.labelAllLocales;
      result.inputTipAllLocales = this.inputTipAllLocales;
      return result;
    }

    public Builder type(AttributeDefinitionType type) {
      this.type = type;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder label(String label) {
      this.label = label;
      return this;
    }

    public Builder isRequired(Boolean isRequired) {
      this.isRequired = isRequired;
      return this;
    }

    public Builder attributeConstraint(AttributeConstraint attributeConstraint) {
      this.attributeConstraint = attributeConstraint;
      return this;
    }

    public Builder inputTip(String inputTip) {
      this.inputTip = inputTip;
      return this;
    }

    public Builder inputHint(TextInputHint inputHint) {
      this.inputHint = inputHint;
      return this;
    }

    public Builder isSearchable(Boolean isSearchable) {
      this.isSearchable = isSearchable;
      return this;
    }

    public Builder labelAllLocales(List<LocalizedString> labelAllLocales) {
      this.labelAllLocales = labelAllLocales;
      return this;
    }

    public Builder inputTipAllLocales(List<LocalizedString> inputTipAllLocales) {
      this.inputTipAllLocales = inputTipAllLocales;
      return this;
    }
  }
}
