package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class AttributeDefinitionDraft {
  private AttributeTypeDraft type;

  private String name;

  private List<LocalizedStringItemInputType> label;

  private Boolean isRequired;

  private AttributeConstraint attributeConstraint;

  private List<LocalizedStringItemInputType> inputTip;

  private TextInputHint inputHint;

  private Boolean isSearchable;

  public AttributeDefinitionDraft() {
  }

  public AttributeDefinitionDraft(AttributeTypeDraft type, String name,
      List<LocalizedStringItemInputType> label, Boolean isRequired,
      AttributeConstraint attributeConstraint, List<LocalizedStringItemInputType> inputTip,
      TextInputHint inputHint, Boolean isSearchable) {
    this.type = type;
    this.name = name;
    this.label = label;
    this.isRequired = isRequired;
    this.attributeConstraint = attributeConstraint;
    this.inputTip = inputTip;
    this.inputHint = inputHint;
    this.isSearchable = isSearchable;
  }

  public AttributeTypeDraft getType() {
    return type;
  }

  public void setType(AttributeTypeDraft type) {
    this.type = type;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<LocalizedStringItemInputType> getLabel() {
    return label;
  }

  public void setLabel(List<LocalizedStringItemInputType> label) {
    this.label = label;
  }

  public Boolean getIsRequired() {
    return isRequired;
  }

  public void setIsRequired(Boolean isRequired) {
    this.isRequired = isRequired;
  }

  public AttributeConstraint getAttributeConstraint() {
    return attributeConstraint;
  }

  public void setAttributeConstraint(AttributeConstraint attributeConstraint) {
    this.attributeConstraint = attributeConstraint;
  }

  public List<LocalizedStringItemInputType> getInputTip() {
    return inputTip;
  }

  public void setInputTip(List<LocalizedStringItemInputType> inputTip) {
    this.inputTip = inputTip;
  }

  public TextInputHint getInputHint() {
    return inputHint;
  }

  public void setInputHint(TextInputHint inputHint) {
    this.inputHint = inputHint;
  }

  public Boolean getIsSearchable() {
    return isSearchable;
  }

  public void setIsSearchable(Boolean isSearchable) {
    this.isSearchable = isSearchable;
  }

  @Override
  public String toString() {
    return "AttributeDefinitionDraft{type='" + type + "', name='" + name + "', label='" + label + "', isRequired='" + isRequired + "', attributeConstraint='" + attributeConstraint + "', inputTip='" + inputTip + "', inputHint='" + inputHint + "', isSearchable='" + isSearchable + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AttributeDefinitionDraft that = (AttributeDefinitionDraft) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(name, that.name) &&
        Objects.equals(label, that.label) &&
        Objects.equals(isRequired, that.isRequired) &&
        Objects.equals(attributeConstraint, that.attributeConstraint) &&
        Objects.equals(inputTip, that.inputTip) &&
        Objects.equals(inputHint, that.inputHint) &&
        Objects.equals(isSearchable, that.isSearchable);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, name, label, isRequired, attributeConstraint, inputTip, inputHint, isSearchable);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AttributeTypeDraft type;

    private String name;

    private List<LocalizedStringItemInputType> label;

    private Boolean isRequired;

    private AttributeConstraint attributeConstraint;

    private List<LocalizedStringItemInputType> inputTip;

    private TextInputHint inputHint;

    private Boolean isSearchable;

    public AttributeDefinitionDraft build() {
      AttributeDefinitionDraft result = new AttributeDefinitionDraft();
      result.type = this.type;
      result.name = this.name;
      result.label = this.label;
      result.isRequired = this.isRequired;
      result.attributeConstraint = this.attributeConstraint;
      result.inputTip = this.inputTip;
      result.inputHint = this.inputHint;
      result.isSearchable = this.isSearchable;
      return result;
    }

    public Builder type(AttributeTypeDraft type) {
      this.type = type;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder label(List<LocalizedStringItemInputType> label) {
      this.label = label;
      return this;
    }

    public Builder isRequired(Boolean isRequired) {
      this.isRequired = isRequired;
      return this;
    }

    public Builder attributeConstraint(AttributeConstraint attributeConstraint) {
      this.attributeConstraint = attributeConstraint;
      return this;
    }

    public Builder inputTip(List<LocalizedStringItemInputType> inputTip) {
      this.inputTip = inputTip;
      return this;
    }

    public Builder inputHint(TextInputHint inputHint) {
      this.inputHint = inputHint;
      return this;
    }

    public Builder isSearchable(Boolean isSearchable) {
      this.isSearchable = isSearchable;
      return this;
    }
  }
}
