package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

/**
 * (https://docs.commercetools.com/api/projects/productTypes#attributetype)[https://docs.commercetools.com/api/projects/productTypes#attributetype]
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = BooleanAttributeDefinitionType.class, name = "BooleanAttributeDefinitionType"),
    @JsonSubTypes.Type(value = DateAttributeDefinitionType.class, name = "DateAttributeDefinitionType"),
    @JsonSubTypes.Type(value = DateTimeAttributeDefinitionType.class, name = "DateTimeAttributeDefinitionType"),
    @JsonSubTypes.Type(value = EnumAttributeDefinitionType.class, name = "EnumAttributeDefinitionType"),
    @JsonSubTypes.Type(value = LocalizableEnumAttributeDefinitionType.class, name = "LocalizableEnumAttributeDefinitionType"),
    @JsonSubTypes.Type(value = LocalizableTextAttributeDefinitionType.class, name = "LocalizableTextAttributeDefinitionType"),
    @JsonSubTypes.Type(value = MoneyAttributeDefinitionType.class, name = "MoneyAttributeDefinitionType"),
    @JsonSubTypes.Type(value = NestedAttributeDefinitionType.class, name = "NestedAttributeDefinitionType"),
    @JsonSubTypes.Type(value = NumberAttributeDefinitionType.class, name = "NumberAttributeDefinitionType"),
    @JsonSubTypes.Type(value = ReferenceAttributeDefinitionType.class, name = "ReferenceAttributeDefinitionType"),
    @JsonSubTypes.Type(value = SetAttributeDefinitionType.class, name = "SetAttributeDefinitionType"),
    @JsonSubTypes.Type(value = TextAttributeDefinitionType.class, name = "TextAttributeDefinitionType"),
    @JsonSubTypes.Type(value = TimeAttributeDefinitionType.class, name = "TimeAttributeDefinitionType")
})
public interface AttributeDefinitionType {
  String getName();

  void setName(String name);
}
