package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AttributeGroupUpdateAction {
  private AddAttributeGroupAttribute addAttribute;

  private ChangeAttributeGroupName changeName;

  private RemoveAttributeGroupAttribute removeAttribute;

  private SetAttributeGroupDescription setDescription;

  private SetAttributeGroupKey setKey;

  private SetAttributeGroupAttributes setAttributes;

  public AttributeGroupUpdateAction() {
  }

  public AttributeGroupUpdateAction(AddAttributeGroupAttribute addAttribute,
      ChangeAttributeGroupName changeName, RemoveAttributeGroupAttribute removeAttribute,
      SetAttributeGroupDescription setDescription, SetAttributeGroupKey setKey,
      SetAttributeGroupAttributes setAttributes) {
    this.addAttribute = addAttribute;
    this.changeName = changeName;
    this.removeAttribute = removeAttribute;
    this.setDescription = setDescription;
    this.setKey = setKey;
    this.setAttributes = setAttributes;
  }

  public AddAttributeGroupAttribute getAddAttribute() {
    return addAttribute;
  }

  public void setAddAttribute(AddAttributeGroupAttribute addAttribute) {
    this.addAttribute = addAttribute;
  }

  public ChangeAttributeGroupName getChangeName() {
    return changeName;
  }

  public void setChangeName(ChangeAttributeGroupName changeName) {
    this.changeName = changeName;
  }

  public RemoveAttributeGroupAttribute getRemoveAttribute() {
    return removeAttribute;
  }

  public void setRemoveAttribute(RemoveAttributeGroupAttribute removeAttribute) {
    this.removeAttribute = removeAttribute;
  }

  public SetAttributeGroupDescription getSetDescription() {
    return setDescription;
  }

  public void setSetDescription(SetAttributeGroupDescription setDescription) {
    this.setDescription = setDescription;
  }

  public SetAttributeGroupKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetAttributeGroupKey setKey) {
    this.setKey = setKey;
  }

  public SetAttributeGroupAttributes getSetAttributes() {
    return setAttributes;
  }

  public void setSetAttributes(SetAttributeGroupAttributes setAttributes) {
    this.setAttributes = setAttributes;
  }

  @Override
  public String toString() {
    return "AttributeGroupUpdateAction{addAttribute='" + addAttribute + "', changeName='" + changeName + "', removeAttribute='" + removeAttribute + "', setDescription='" + setDescription + "', setKey='" + setKey + "', setAttributes='" + setAttributes + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AttributeGroupUpdateAction that = (AttributeGroupUpdateAction) o;
    return Objects.equals(addAttribute, that.addAttribute) &&
        Objects.equals(changeName, that.changeName) &&
        Objects.equals(removeAttribute, that.removeAttribute) &&
        Objects.equals(setDescription, that.setDescription) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setAttributes, that.setAttributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addAttribute, changeName, removeAttribute, setDescription, setKey, setAttributes);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddAttributeGroupAttribute addAttribute;

    private ChangeAttributeGroupName changeName;

    private RemoveAttributeGroupAttribute removeAttribute;

    private SetAttributeGroupDescription setDescription;

    private SetAttributeGroupKey setKey;

    private SetAttributeGroupAttributes setAttributes;

    public AttributeGroupUpdateAction build() {
      AttributeGroupUpdateAction result = new AttributeGroupUpdateAction();
      result.addAttribute = this.addAttribute;
      result.changeName = this.changeName;
      result.removeAttribute = this.removeAttribute;
      result.setDescription = this.setDescription;
      result.setKey = this.setKey;
      result.setAttributes = this.setAttributes;
      return result;
    }

    public Builder addAttribute(AddAttributeGroupAttribute addAttribute) {
      this.addAttribute = addAttribute;
      return this;
    }

    public Builder changeName(ChangeAttributeGroupName changeName) {
      this.changeName = changeName;
      return this;
    }

    public Builder removeAttribute(RemoveAttributeGroupAttribute removeAttribute) {
      this.removeAttribute = removeAttribute;
      return this;
    }

    public Builder setDescription(SetAttributeGroupDescription setDescription) {
      this.setDescription = setDescription;
      return this;
    }

    public Builder setKey(SetAttributeGroupKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setAttributes(SetAttributeGroupAttributes setAttributes) {
      this.setAttributes = setAttributes;
      return this;
    }
  }
}
