package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AttributeSetTypeDraft {
  private AttributeSetElementTypeDraft elementType;

  public AttributeSetTypeDraft() {
  }

  public AttributeSetTypeDraft(AttributeSetElementTypeDraft elementType) {
    this.elementType = elementType;
  }

  public AttributeSetElementTypeDraft getElementType() {
    return elementType;
  }

  public void setElementType(AttributeSetElementTypeDraft elementType) {
    this.elementType = elementType;
  }

  @Override
  public String toString() {
    return "AttributeSetTypeDraft{elementType='" + elementType + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AttributeSetTypeDraft that = (AttributeSetTypeDraft) o;
    return Objects.equals(elementType, that.elementType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(elementType);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AttributeSetElementTypeDraft elementType;

    public AttributeSetTypeDraft build() {
      AttributeSetTypeDraft result = new AttributeSetTypeDraft();
      result.elementType = this.elementType;
      return result;
    }

    public Builder elementType(AttributeSetElementTypeDraft elementType) {
      this.elementType = elementType;
      return this;
    }
  }
}
