package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AuthorizationHeaderInput {
  private String headerValue;

  public AuthorizationHeaderInput() {
  }

  public AuthorizationHeaderInput(String headerValue) {
    this.headerValue = headerValue;
  }

  public String getHeaderValue() {
    return headerValue;
  }

  public void setHeaderValue(String headerValue) {
    this.headerValue = headerValue;
  }

  @Override
  public String toString() {
    return "AuthorizationHeaderInput{headerValue='" + headerValue + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AuthorizationHeaderInput that = (AuthorizationHeaderInput) o;
    return Objects.equals(headerValue, that.headerValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(headerValue);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String headerValue;

    public AuthorizationHeaderInput build() {
      AuthorizationHeaderInput result = new AuthorizationHeaderInput();
      result.headerValue = this.headerValue;
      return result;
    }

    public Builder headerValue(String headerValue) {
      this.headerValue = headerValue;
      return this;
    }
  }
}
